VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMedia"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Media Player Management Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long

'Winamp get/set
Private Const IPC_GETOUTPUTTIME = 105
Private Const IPC_SETPLAYLISTPOS = 121
Private Const IPC_SETVOLUME = 122
Private Const IPC_GETLISTLENGTH = 124
Private Const IPC_GETLISTPOS = 125

'Foobar Commands
Private Const FOOBAR_PAUS        As Long = 40044
Private Const FOOBAR_STOP        As Long = 40010
Private Const FOOBAR_PLAY        As Long = 40009
Private Const FOOBAR_NEXT        As Long = 40011
Private Const FOOBAR_PREV        As Long = 40051

'Winamp Commands
Private Const WINAMP_PREV        As Long = &H9C6C
Private Const WINAMP_PLAY        As Long = &H9C6D
Private Const WINAMP_PAUS        As Long = &H9C6E
Private Const WINAMP_STOP        As Long = &H9C6F
Private Const WINAMP_NEXT        As Long = &H9C70

'KbMedia Player Commands
Private Const KB_PREV            As Long = &H13
Private Const KB_PLAY            As Long = &HD
Private Const KB_PAUS            As Long = &HE
Private Const KB_NEXT            As Long = &H12
Private Const KB_STOP            As Long = &HF

'Windows Media Player Commands
Private Const WMP_PLAY           As Long = &H4978
Private Const WMP_PAUS           As Long = &H4978
Private Const WMP_STOP           As Long = &H4979
Private Const WMP_PREV           As Long = &H497A
Private Const WMP_NEXT           As Long = &H497B

Private IA As iTunesApp
Private mMediaPlayer As MEDIAPLAYERS
Public CurrentTrack As String
Public Enum MEDIAPLAYERS
    None& = 0
    iTunes& = 1
    Foobar& = 2
    Winamp& = 3
    WindowsMediaPlayer& = 4
    Lastfm& = 5
    Kb& = 6
    MediaMonkey& = 7
    MediaPC& = 8
End Enum

Public Property Let MediaPlayer(Value As MEDIAPLAYERS)
    mMediaPlayer = Value
    If Value = iTunes Then
        If Opened Then
            Unload frmiTunes
            Load frmiTunes
        End If
    Else
        Unload frmiTunes
    End If
End Property

Public Property Get MediaPlayer() As MEDIAPLAYERS
    MediaPlayer = mMediaPlayer
End Property

Public Property Get MediaPlayerToString() As String
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        MediaPlayerToString = "foobar2000"
    Case MEDIAPLAYERS.iTunes
        MediaPlayerToString = "iTunes"
    Case MEDIAPLAYERS.Winamp
        MediaPlayerToString = "Winamp"
    Case MEDIAPLAYERS.WindowsMediaPlayer
        MediaPlayerToString = "Windows Media Player"
    Case MEDIAPLAYERS.Kb
        MediaPlayerToString = "KbMedia Player"
    Case MEDIAPLAYERS.Lastfm
        MediaPlayerToString = "Last.fm"
    Case MEDIAPLAYERS.MediaMonkey
        MediaPlayerToString = "MediaMonkey"
    Case MEDIAPLAYERS.MediaPC
        MediaPlayerToString = "Media Player Classic"
    Case Else
        MediaPlayerToString = "None"
    End Select
End Property

Private Function FoobarHandle() As Long
    FoobarHandle = _
        FindWindow("{97E27FAA-C0B3-4b8e-A693-ED7881E99FC1}", vbNullString) Or _
        FindWindow("{E7076D1C-A7BF-4f39-B771-BCBE88F2A2A8}", vbNullString) Or _
        FindWindow("{DA7CD0DE-1602-45e6-89A1-C2CA151E008E}/1", vbNullString)
End Function

Private Function MediaMonkeyHandle() As Long
    MediaMonkeyHandle = WinampHandle
End Function

Private Function MediaPcHandle() As Long
    MediaPcHandle = FindWindow("MediaPlayerClassicW", vbNullString)
End Function

Private Function WinampHandle() As Long
    WinampHandle = FindWindow("Winamp v1.x", vbNullString)
End Function

Public Function LastfmHandle() As Long
    Dim tempHwnd As Long
    tempHwnd = FindWindow("QWidget", vbNullString)
    Do Until tempHwnd = 0 Or Err
        Dim str As String, R As Long
        str = Space$(256)
        R = GetWindowText(tempHwnd, str, 256)
        str = Left$(str, R)
        If InStr(str, "  ") > 0 Or str = "Last.fm" Then
            LastfmHandle = tempHwnd
            Exit Do
        End If
        tempHwnd = GetWindow(tempHwnd, 2)
    Loop
    'Enumerate through the process list, when it comes to "LastFM.exe", _
     get it's pID, store it, get info, there ya go.
End Function

Private Function KbHandle() As Long
    KbHandle = FindWindow("TFrmMIDI", vbNullString)
End Function

Private Function iTunesHandle() As Long
    iTunesHandle = FindWindow("iTunes", vbNullString)
End Function

Private Function WmpHandle() As Long
    WmpHandle = FindWindow("WMPlayerApp", vbNullString)
End Function

Public Function Opened() As Boolean
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Opened = (FoobarHandle <> 0)
    Case MEDIAPLAYERS.iTunes
        Opened = (iTunesHandle <> 0)
    Case MEDIAPLAYERS.Winamp
        Opened = (WinampHandle <> 0)
        If Opened Then If InStrB(GetTitle(MediaMonkeyHandle), "MediaMonkey") <> 0 Then Opened = False
    Case MEDIAPLAYERS.Kb
        Opened = (KbHandle <> 0)
    Case MEDIAPLAYERS.MediaMonkey
        Opened = (MediaMonkeyHandle <> 0)
        If Opened Then If InStrB(GetTitle(MediaMonkeyHandle), "Winamp") <> 0 Then Opened = False
    Case MEDIAPLAYERS.MediaPC
        Opened = (MediaPcHandle <> 0)
    Case MEDIAPLAYERS.Lastfm
        Opened = (LastfmHandle <> 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Opened = (WmpHandle <> 0)
    End Select
End Function

Public Sub BeginPlay()
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_COMMAND, FOOBAR_PLAY, 0)
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        IA.Play
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PLAY, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PLAY, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PLAY, 0)
    Case MEDIAPLAYERS.MediaPC
        Call PostMessage(MediaPcHandle, WM_COMMAND, 887, 0)
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Play
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "BeginPlay"
End Sub

Public Sub StopPlay()
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_COMMAND, FOOBAR_STOP, 0)
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        IA.Stop
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_STOP, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_STOP, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_STOP, 0)
    Case MEDIAPLAYERS.MediaPC
        Call PostMessage(MediaPcHandle, WM_COMMAND, 890, 0)
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Stop
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "StopPlay"
End Sub

Public Sub PausePlay()
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_COMMAND, FOOBAR_PAUS, 0)
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        IA.Pause
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PAUS, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PAUS, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PAUS, 0)
    Case MEDIAPLAYERS.MediaPC
        Call PostMessage(MediaPcHandle, WM_COMMAND, 888, 0)
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Pause
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "PausePlay"
End Sub

Public Sub PlaySongName(strName As String)
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
    
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        If LenB(strName) <> 0 Then
            Dim Tracks As IITTrackCollection
            Set Tracks = IA.LibraryPlaylist.Search(strName, 0)
            If Not Tracks Is Nothing Then
                Tracks(1).Play
                Exit Sub
            End If
            Set Tracks = Nothing
        End If
        
    Case MEDIAPLAYERS.Kb
    
    Case MEDIAPLAYERS.Winamp
        Dim lngJumpto As Long, lngEdit As Long, lngListBox As Long
        Call PostMessage(WinampHandle, 273, 40194, 0)
        Do
            DoEvents
            lngJumpto = FindWindow("#32770", "Jump to file")
            lngEdit = FindWindowEx(lngJumpto, 0, "Edit", vbNullString)
            lngListBox = FindWindowEx(lngJumpto, 0, "ListBox", vbNullString)
        Loop Until (lngJumpto <> 0 And lngEdit <> 0 And lngListBox <> 0)
        SendMessageByString lngEdit, &HC, 0, strName
        DoEvents
        If SendMessageLong(lngListBox, &H18B, 0, 0) = 0 Then
            PostMessage lngJumpto, &H10, 0, 0
        Else
            SendMessageLong lngListBox, &H203, 0, 0
        End If

    Case MEDIAPLAYERS.WindowsMediaPlayer
    
    Case MEDIAPLAYERS.MediaPC
    
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Pause
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "PlaySongName"
End Sub

Public Sub PlaySong(intPosition As Integer)
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
    
    Case MEDIAPLAYERS.iTunes
        
    Case MEDIAPLAYERS.Kb
    
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_WA_IPC, intPosition, IPC_SETPLAYLISTPOS)
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PLAY, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
    
    Case MEDIAPLAYERS.MediaPC
    
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Pause
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "PlaySong"
End Sub

Public Sub PlaylistPosition(ByRef Position As Long, ByRef Length As Long)
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
    
    Case MEDIAPLAYERS.iTunes
    
    Case MEDIAPLAYERS.Kb
    
    Case MEDIAPLAYERS.Winamp
        Position = SendMessage(WinampHandle, WM_WA_IPC, 0, IPC_GETLISTPOS)
        Length = SendMessage(WinampHandle, WM_WA_IPC, 0, IPC_GETLISTLENGTH)
    Case MEDIAPLAYERS.WindowsMediaPlayer
    
    Case MEDIAPLAYERS.MediaPC
    
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Pause
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "PlaylistPosition"
End Sub

Public Sub NextTrack()
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_COMMAND, FOOBAR_NEXT, 0)
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        IA.NextTrack
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_NEXT, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_NEXT, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_NEXT, 0)
    Case MEDIAPLAYERS.MediaPC
        Call PostMessage(MediaPcHandle, WM_COMMAND, 921, 0)
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Next
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "NextTrack"
End Sub

Public Sub PreviousTrack()
On Error GoTo hErr
    If Not Opened Then Exit Sub
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar
        Call PostMessage(FoobarHandle, WM_COMMAND, FOOBAR_PREV, 0)
    Case MEDIAPLAYERS.iTunes
        Set IA = New iTunesApp
        IA.BackTrack
    Case MEDIAPLAYERS.Kb
        Call PostMessage(KbHandle, WM_COMMAND, KB_PREV, 0)
    Case MEDIAPLAYERS.Winamp
        Call PostMessage(WinampHandle, WM_COMMAND, WINAMP_PREV, 0)
    Case MEDIAPLAYERS.WindowsMediaPlayer
        Call PostMessage(WmpHandle, WM_COMMAND, WMP_PREV, 0)
    Case MEDIAPLAYERS.MediaPC
        Call PostMessage(MediaPcHandle, WM_COMMAND, 920, 0)
    Case MEDIAPLAYERS.MediaMonkey
        Dim SDB As Object
        Set SDB = CreateObject("SongsDB.SDBPlayer")
        SDB.Previous
        Set SDB = Nothing
    End Select
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Media", "PreviousTrack"
End Sub

Private Function GetTitle(Handle As Long) As String
On Error GoTo hErr
    Dim bufLen As Long, buf As String, N As Integer
        bufLen = SendMessage(Handle, &HE, &H0, ByVal &H0)
        buf = String$(bufLen, 0)
    SendMessage Handle, &HD, bufLen + 1, ByVal buf
        buf = Replace$(buf, "_", Space$(1))
        buf = Replace$(buf, Space$(2), Space$(1))
    N = InStr(buf, ". ")
        If N <> 0 Then If CStr(Val(Left$(buf, N - 1))) = Left$(buf, N - 1) Then buf = Mid$(buf, N + 1)
    N = InStr(buf, "[foobar")
        If N <> 0 Then buf = Left$(buf, N - 1)
    N = InStr(buf, " - MediaMonkey")
        If N <> 0 Then buf = Left$(buf, N - 1)
    N = InStr(buf, " - Windows Media Player")
        If N <> 0 Then buf = Left$(buf, N - 1)
    N = InStr(buf, " - Winamp")
        If N <> 0 Then buf = Left$(buf, N - 1)
    N = InStr(buf, " - Media Player Classic")
        If N <> 0 Then buf = Left$(buf, N - 1)
    GetTitle = buf
    Exit Function
hErr:
    ErrorHandler Err, Erl, "Media", "GetTitle"
End Function

Public Function Track() As String
    If Not Opened Then Track = MediaPlayerToString & " is not running!": Exit Function
    
On Error GoTo hErr
    Select Case mMediaPlayer
    Case MEDIAPLAYERS.Foobar:               Track = GetTitle(FoobarHandle)
    Case MEDIAPLAYERS.iTunes:               Track = CurrentTrack
    Case MEDIAPLAYERS.Winamp:               Track = GetTitle(WinampHandle)
    Case MEDIAPLAYERS.Lastfm:               Track = GetTitle(LastfmHandle)
    Case MEDIAPLAYERS.MediaMonkey:          Track = GetTitle(MediaMonkeyHandle)
    Case MEDIAPLAYERS.MediaPC:              Track = GetTitle(MediaPcHandle)
    Case MEDIAPLAYERS.Kb:                   Track = GetTitle(KbHandle)
    Case MEDIAPLAYERS.WindowsMediaPlayer:   Track = GetTitle(WmpHandle)
    End Select
    
hErr:
    If (Track = "Windows Media Player") Then Track = "Blogging plugin not running or playback has not started!": Exit Function
    If (Track = "- KbMedia Player -") Then Track = "Not playing!": Exit Function
    If (Track = "Last.fm") Then Track = "Not playing!": Exit Function
    If (Left$(Track, 10) = "foobar2000") Then Track = "Not playing!": Exit Function
    If (InStrB(Track, " - KbMedia Player -") <> 0) Then Track = Replace$(Trim$(Track), " - KbMedia Player -", vbNullString)
    If (InStrB(Track, Chr$(150)) <> 0) Then Track = Replace$(Track, Chr$(150), Chr$(45))
    If (Len(Track) = 0) Then Track = "Not playing!": Exit Function
    If (Left$(Track, 1) = "[") And (Right$(Track, 1) = "]") Then Track = Mid$(Track, 2, Len(Track) - 2)
End Function
